<?php
    
    if ( ! defined( 'ABSPATH' ) ) { exit;}
    
    class ATTO_interface
        {
            
            function admin_scripts()
                {
                    
                    wp_enqueue_script('jquery');
                    
                    wp_enqueue_script('jquery-ui-core');
                    wp_enqueue_script('jquery-ui-sortable');
                    wp_enqueue_script('jquery-ui-widget');
                    wp_enqueue_script('jquery-ui-mouse');
                    
                    $myJavascriptFile = ATTO_URL . '/js/touch-punch.min.js';
                    wp_register_script('touch-punch.min.js', $myJavascriptFile, array(), ATTO_VERSION, TRUE);
                    wp_enqueue_script( 'touch-punch.min.js');
                       
                    $myJavascriptFile = ATTO_URL . '/js/nested-sortable.js';
                    wp_register_script('nested-sortable.js', $myJavascriptFile, array(), ATTO_VERSION, TRUE);
                    wp_enqueue_script( 'nested-sortable.js');
                    
                    wp_register_script('to-javascript.js', ATTO_URL . '/js/to-javascript.js', array(), ATTO_VERSION, FALSE );
                    wp_enqueue_script( 'to-javascript.js');
                       
                }
                
            
            function admin_styles()
                {
                    wp_register_style('to.css', ATTO_URL . '/css/to.css', array(), ATTO_VERSION );
                    wp_enqueue_style( 'to.css');
                }
            
            
            function admin_interface()
                {
                    global $wpdb, $wp_locale;
                    
                    $options    =   ATTO_functions::get_settings();
                      
                    $taxonomy   =   isset($_REQUEST['taxonomy']) ? preg_replace( '/[^a-zA-Z0-9_\-]/', '', wp_unslash ( $_REQUEST['taxonomy'] ) ) : '';
                    $post_type  =   isset($_REQUEST['post_type']) ? preg_replace( '/[^a-zA-Z0-9_\-]/', '', wp_unslash ( $_REQUEST['post_type'] ) ) : '';
                    
                    if( empty ( $post_type ) )
                        {
                            $screen = get_current_screen();
                            
                            if(isset($screen->post_type)    && !empty($screen->post_type))
                                $post_type  =   $screen->post_type;
                                else
                                {
                                    switch($screen->parent_file)
                                        {
                                            case "upload.php" :
                                                                        $post_type  =   'attachment';
                                                                        break;
                                                                
                                            case "shopp-products"   :
                                                                        $post_type  =   'shopp_product';
                                                                        break;
                                                        
                                            default:
                                                                        $post_type  =   'post';   
                                        }
                                }       
                        }
                        
                    $post_type   =   apply_filters('atto/interface/post_type', $post_type );
                            
                    $post_type_taxonomies = get_object_taxonomies($post_type);
                
                    $post_type_taxonomies   =   apply_filters('atto/interface/post_type_taxonomies', $post_type_taxonomies);
                
                    //use the first taxonomy if emtpy taxonomy
                    if ($taxonomy == '' || !taxonomy_exists($taxonomy))
                        {
                            reset($post_type_taxonomies);   
                            $taxonomy = current($post_type_taxonomies);
                        }
                                        
                    $post_type_data = get_post_type_object($post_type);
                    
                    if (!taxonomy_exists($taxonomy))
                        $taxonomy = '';
                    
                    //set as default for auto
                    $order_type = (isset($options['taxonomy_settings'][$taxonomy]['order_type'])) ? $options['taxonomy_settings'][$taxonomy]['order_type'] : 'manual'; 
                    
                    
                    $taxonomy_info = get_taxonomy($taxonomy);
                    
                    
                    if (isset($_GET['switch_order_type']))
                        {
                            $order_type =   preg_replace( '/[^a-zA-Z0-9_\-]/', '', wp_unslash ( $_GET['switch_order_type'] ) );
                                      
                            //save the new order
                            $options['taxonomy_settings'][$taxonomy]['order_type'] = $order_type;
                            update_option('tto_options', $options); 
                            
                            echo '<div class="message updated fade"><p>'. sprintf( esc_html__('Order type for %s', 'advanced-taxonomy-terms-order'), esc_attr ( $taxonomy_info->label ) ) .' '. sprintf( esc_html__('switched to %s', 'advanced-taxonomy-terms-order'), esc_attr ( ucfirst ( $order_type ) ) )  .'</p></div>';
                        }
                                
                    //check for order type update
                    if (isset($_POST['order_type']))
                        {
                            $new_order_type     =   preg_replace( '/[^a-zA-Z0-9_\-]/', '', wp_unslash ( $_POST['order_type'] ) ); 
                            if ($new_order_type != 'auto' && $new_order_type != 'manual')
                                $new_order_type = '';
                                
                            if ($new_order_type != '')
                                {
                                    
                                    echo '<div class="message updated fade"><p>'. esc_html__('Order updated','advanced-taxonomy-terms-order') .'</p></div>';
                                    $order_type = $new_order_type;
                                    
                                    //save the new order
                                    $options['taxonomy_settings'][$taxonomy]['order_type'] = $order_type;

                                    //update the orde_by
                                    if (isset($_POST['auto_order_by']))
                                        {
                                            $new_order_by =     preg_replace( '/[^a-zA-Z0-9_\-]/', '', wp_unslash ( $_POST['auto_order_by'] ) );
                                            if ($new_order_by != '')
                                                $options['taxonomy_settings'][$taxonomy]['auto']['order_by'] = $new_order_by;
                                        } 
                                    
                                    //update the orde_by
                                    if (isset($_POST['auto_order']))
                                        {
                                            $new_order =    preg_replace( '/[^a-zA-Z0-9_\-]/', '', wp_unslash ( $_POST['auto_order'] ) );
                                            if ($new_order_by != '')
                                                $options['taxonomy_settings'][$taxonomy]['auto']['order'] = $new_order;
                                        }    
                                        
                                    update_option('tto_options', $options);                        
                                }
                        }
                    
                    if(isset($taxonomy_info->hierarchical) && $taxonomy_info->hierarchical === TRUE)    
                        $is_hierarchical = TRUE;
                        else
                        $is_hierarchical = FALSE;

                    
                    $current_section_parent_file    =   '';
             
                    switch($post_type)
                        {
                            case "post" :
                                            $current_section_parent_file    =    "edit.php";
                                            break;
                            case "attachment" :
                                            $current_section_parent_file    =   "upload.php";
                                            break;
                        }
            
                    ?>    
                    <div id="atto" class="wrap">
                        <h2><?php echo esc_html ( apply_filters ( 'atto/admin/interface_title', esc_html__( 'Taxonomy Order', 'advanced-taxonomy-terms-order' ) ) ) ?></h2>

                        <div id="ajax-response"></div>
                        
                        <noscript>
                            <div class="error message">
                                <p><?php esc_html_e("This plugin cannot work without javascript, because it uses drag and drop and AJAX.", 'advanced-taxonomy-terms-order') ?></p>
                            </div>
                        </noscript>

                        <div class="clear"></div>
                        
                        <?php do_action('ato_interface_before_form'); ?>
                        
                        <form action="<?php  echo esc_html ( $current_section_parent_file ) ?>" method="get" id="to_form">
                            <input type="hidden" name="page" value="<?php 
                                
                                $current_interface_page =   apply_filters('atto/interface/current_page', 'to-interface-' . $post_type, $post_type );
                                echo esc_html ( $current_interface_page );
                            
                            ?>" />
                            <?php
                        
                            $interface_ignore_field =   apply_filters('atto/interface/ignore_field', array( 'post', 'attachment' ));
                            if ( ! in_array ( $post_type, $interface_ignore_field ) )
                                echo '<input type="hidden" name="post_type" value="'. esc_html ( $post_type ) .'" />';

                            
                                                    
                            if ( count ( $post_type_taxonomies ) > 1 )
                                {
                        
                                    ?>
                                    
                                    <h4><?php printf( esc_html__('%s Taxonomies','advanced-taxonomy-terms-order'), esc_attr( ucfirst ( $post_type_data->labels->name ) ) ) ?></h4>
                                    <table cellspacing="0" class="wp-list-taxonomy widefat fixed">
                                        <thead>
                                        <tr>
                                            <th style="" class="column-cb check-column" id="cb" scope="col">&nbsp;</th><th style="" class="" id="author" scope="col"><?php esc_html_e('Taxonomy Title', 'advanced-taxonomy-terms-order') ?></th><th style="" class="manage-column" id="categories" scope="col"><?php esc_html_e('Total Terms', 'advanced-taxonomy-terms-order') ?></th>    </tr>
                                        </thead>

                                        <tfoot>
                                        <tr>
                                            <th style="" class="column-cb check-column" id="cb" scope="col">&nbsp;</th><th style="" class="" id="author" scope="col"><?php esc_html_e('Taxonomy Title', 'advanced-taxonomy-terms-order') ?></th><th style="" class="manage-column" id="categories" scope="col"><?php esc_html_e('Total Terms', 'advanced-taxonomy-terms-order') ?></th>    </tr>
                                        </tfoot>

                                        <tbody id="the-list">
                                        <?php
                                            
                                            $alternate = FALSE;
                                            foreach ( $post_type_taxonomies as $key => $post_type_taxonomy )
                                                {
                                                    $taxonomy_info = get_taxonomy($post_type_taxonomy);

                                                    $alternate = $alternate === TRUE ? FALSE :TRUE;
                                                    
                                                    
                                                    $args = array(
                                                                    'hide_empty'    =>  0,
                                                                    'taxonomy'      =>  $post_type_taxonomy
                                                                    );
                                                    $taxonomy_terms = get_terms ( $args );
                                                                     
                                                    ?>
                                                        <tr valign="top" class="<?php if ($alternate === TRUE) {echo 'alternate ';} ?>" id="taxonomy-<?php echo esc_attr ( $taxonomy )  ?>">
                                                                <th class="check-column" scope="row"><input type="radio" onclick="ATTO.change_taxonomy(this)" value="<?php echo esc_attr ( $post_type_taxonomy ) ?>" <?php if ( $post_type_taxonomy == $taxonomy ) {echo 'checked="checked"';} ?> name="taxonomy">&nbsp;</th>
                                                                <td class="categories column-categories"><b><?php echo esc_attr ( $taxonomy_info->label ) ?></b> (<?php echo  esc_attr ( $taxonomy_info->labels->singular_name ); ?>)</td>
                                                                <td class="categories column-categories"><?php echo count($taxonomy_terms) ?></td>
                                                        </tr>
                                                    
                                                    <?php
                                                }
                                        ?>
                                        </tbody>
                                    </table>
                                    <br /><br /> 
                                    <?php
                                }
                                    ?>
                        </form>
                      
                        <script type="text/javascript">    

                            var taxonomy    = '<?php echo esc_attr ( $taxonomy ) ?>';

                        </script>
                       
                       
                        <?php

                            $url_query_vars =   array(
                                                        "page"          =>  "to-interface-" .   $post_type,
                                                        "taxonomy"      =>  $taxonomy 
                                                        );

                            if (!in_array($post_type, array('post', 'attachment')))   
                                $url_query_vars['post_type']    =   $post_type;
                         
                        ?>
                        <form action="<?php  echo esc_html ( $current_section_parent_file ) ?>?<?php echo http_build_query($url_query_vars) ?>" method="post" id="to_form">
                            <input type="hidden" name="order_type" value="<?php echo esc_attr ( $order_type ) ?>" />
                            <?php
                        
                            if (!in_array($post_type, array('post', 'attachment')))
                                echo '<input type="hidden" name="post_type" value="'. esc_attr ( $post_type ) .'" />';
                        
                            $url_query_vars =   array(
                                                        "page"          =>  "to-interface-" .   $post_type,
                                                        "taxonomy"      =>  $taxonomy 
                                                        );
                            
                            if (!in_array($post_type, array('post', 'attachment')))   
                                $url_query_vars['post_type']    =   $post_type; 
                             
                            ?>
                        
                        <h2 class="nav-tab-wrapper" id="apto-nav-tab-wrapper">
                            <a href="<?php  echo esc_html ( $current_section_parent_file ) ?>?<?php echo http_build_query(array_merge($url_query_vars, array("switch_order_type" => "auto"))) ?>" class="nav-tab<?php if ( $order_type == 'auto') {echo ' nav-tab-active';} ?>"><?php esc_html_e('Automatic Order', 'advanced-taxonomy-terms-order') ?></a>
                            <a href="<?php  echo esc_html ( $current_section_parent_file ) ?>?<?php echo http_build_query(array_merge($url_query_vars, array("switch_order_type" => "manual"))) ?>" class="nav-tab<?php if ( $order_type == 'manual') {echo ' nav-tab-active';} ?>"><?php esc_html_e('Manual Order', 'advanced-taxonomy-terms-order') ?></a>
                        </h2>
                        <?php if ($order_type == 'auto')
                                {
                                   ?>
                                    <div class="atto_metabox">
                                                           
                                        <table class="widefat">
                                            <tbody>
                                                <tr valign="top">
                                                    <td class="label">
                                                        <label for=""><?php esc_html_e('Order By', 'advanced-taxonomy-terms-order') ?></label>
                                                    </td>
                                                    <td>
                                                        <?php
                                                        
                                                            $auto_order_by = isset($options['taxonomy_settings'][$taxonomy]['auto']['order_by']) ? $options['taxonomy_settings'][$taxonomy]['auto']['order_by'] : 'name';

                                                        ?>
                                                        <input type="radio" <?php if ($auto_order_by == 'default') {echo 'checked="checked"'; } ?> value="default" id="order_by_default" name="auto_order_by" />
                                                        <label for="order_by_default"><?php esc_html_e('Default', 'advanced-taxonomy-terms-order') ?></label><br>
                                                        
                                                        <input type="radio" <?php if ($auto_order_by == 'id') {echo 'checked="checked"'; } ?> value="id" id="order_by_id" name="auto_order_by" />
                                                        <label for="order_by_id"><?php esc_html_e('Creation Time / ID', 'advanced-taxonomy-terms-order') ?></label><br>
                                                        
                                                        <input type="radio" <?php if ($auto_order_by == 'name') {echo 'checked="checked"'; } ?> value="name" id="order_by_name" name="auto_order_by" />
                                                        <label for="order_by_name"><?php esc_html_e('Name', 'advanced-taxonomy-terms-order') ?></label><br>
                                                        
                                                        <input type="radio" <?php if ($auto_order_by == 'count') {echo 'checked="checked"'; } ?> value="count" id="order_by_count" name="auto_order_by" />
                                                        <label for="order_by_count"><?php esc_html_e('Count', 'advanced-taxonomy-terms-order') ?></label><br>
                                                        
                                                        <input type="radio" <?php if ($auto_order_by == 'slug') {echo 'checked="checked"'; } ?> value="slug" id="order_by_slug" name="auto_order_by" />
                                                        <label for="order_by_slug"><?php esc_html_e('Slug', 'advanced-taxonomy-terms-order') ?></label><br>
                                                        
                                                        <input type="radio" <?php if ($auto_order_by == 'random') {echo 'checked="checked"'; } ?> value="random" id="order_by_random" name="auto_order_by" />
                                                        <label for="order_by_random"><?php esc_html_e('Random', 'advanced-taxonomy-terms-order') ?></label><br>
                                                         
                                                    </td>
                                                </tr>
                                       
                                                <tr valign="top">
                                                    <td class="label">
                                                        <label for=""><?php esc_html_e('Order', 'advanced-taxonomy-terms-order') ?></label>
                                                    </td>
                                                    <td>
                                                        <?php
                                                        
                                                            $auto_order = isset($options['taxonomy_settings'][$taxonomy]['auto']['order']) ? $options['taxonomy_settings'][$taxonomy]['auto']['order'] : 'desc';

                                                        ?>
                                                        
                                                        <input type="radio" <?php if ($auto_order == 'desc') {echo 'checked="checked"'; } ?> value="desc" id="order_desc" name="auto_order" />
                                                        <label for="order_desc"><?php esc_html_e('Descending', 'advanced-taxonomy-terms-order') ?></label><br>

                                                        <input type="radio" <?php if ($auto_order == 'asc') {echo 'checked="checked"'; } ?> value="asc" id="order_asc" name="auto_order" />
                                                        <label for="order_asc"><?php esc_html_e('Ascending', 'advanced-taxonomy-terms-order') ?></label><br>
                                                        
                                                    </td>
                                                </tr>
                                                
                                                <tr class="submit">
                                                    <td class="label">&nbsp;</td>
                                            
                                                    <td align="right">
                                                        <input type="submit" value="<?php esc_html_e('Update', 'advanced-taxonomy-terms-order') ?>" class="button-primary" name="update">
                                                    </td>    
                                                </tr>
                                                
                                            </tbody>
                                        </table>
                            
                                        
                                    </div>
                                    
                                    <?php
                                }
                        ?>
                       
                       
                       
                       
                        <?php if ($order_type == 'manual')
                                {
                                    ?>
                                    <div id="order-terms">
                                        
                                        <div id="nav-menu-header">
                                            <div class="major-publishing-actions">

                                                    
                                                    <div class="alignright actions">
                                                        <p class="actions">
                          
                                                            <span class="img_spacer">&nbsp;
                                                                <img alt="" src="<?php echo esc_url ( ATTO_URL . '/images/wpspin_light.gif' ) ?>" class="waiting pto_ajax_loading" style="display: none;">
                                                            </span>
                                                            <a href="javascript:;" class="save-order button-primary"><?php esc_html_e('Update', 'advanced-taxonomy-terms-order') ?></a>
                                                        </p>
                                                    </div>
                                                    
                                                    <div class="clear"></div>

                                            </div><!-- END .major-publishing-actions -->
                                        </div><!-- END #nav-menu-header -->

                                        
                                        <div id="post-body">                    
                                            
                                            
                                            <div id="sort_options">
                                                <a href="javascript: void(0)" onClick="ATTO.interface_reverse_order()"><?php esc_html_e( "Reverse", 'advanced-taxonomy-terms-order' ) ?></a> <span>|</span>
                                                <a href="javascript: void(0)" onClick="ATTO.interface_title_order('ASC')"><?php esc_html_e( "Title Asc", 'advanced-taxonomy-terms-order' ) ?></a> <span>|</span>
                                                <a href="javascript: void(0)" onClick="ATTO.interface_title_order('DESC')"><?php esc_html_e( "Title Desc", 'advanced-taxonomy-terms-order' ) ?></a> <span>|</span>
                                                <a href="javascript: void(0)" onClick="ATTO.interface_id_order('ASC')"><?php esc_html_e( "Id order Asc", 'advanced-taxonomy-terms-order' ) ?></a> <span>|</span>
                                                <a href="javascript: void(0)" onClick="ATTO.interface_id_order('DESC')"><?php esc_html_e( "Id order Desc", 'advanced-taxonomy-terms-order' ) ?></a> <span>|</span>
                                                <a href="javascript: void(0)" onClick="ATTO.interface_random_order()"><?php esc_html_e( "Random", 'advanced-taxonomy-terms-order' ) ?></a>
                                                
                                                <a class="alignright" href="javascript: void(0)" onClick="ATTO.interface_collapse()"><?php esc_html_e( "Collapse All", 'advanced-taxonomy-terms-order' ) ?></a> &nbsp;<span class="alignright">|</span> 
                                                <a class="alignright" href="javascript: void(0)" onClick="ATTO.interface_expand()"><?php esc_html_e( "Expand All", 'advanced-taxonomy-terms-order' ) ?></a>
                                            </div>
                                             
                                            <ul id="sortable">
                                                <?php 
                                                    
                                                    $this->list_terms($taxonomy); 
                                                    
                                                ?>
                                            </ul>
                                            
                                            <div class="clear"></div>
                                        </div>
                                        
                                        <div id="nav-menu-footer">
                                            <div class="major-publishing-actions">
                                                    <div class="alignright actions">
                                                        <img alt="" src="<?php echo esc_url ( ATTO_URL . '/images/wpspin_light.gif' ) ?>" class="waiting pto_ajax_loading" style="display: none;">
                                                        <a href="javascript:;" class="save-order button-primary"><?php esc_html_e('Update', 'advanced-taxonomy-terms-order') ?></a>
                                                    </div>
                                                    
                                                    <div class="clear"></div>

                                            </div><!-- END .major-publishing-actions -->
                                        </div><!-- END #nav-menu-header -->
                                        
                                    </div>
                                    
                                    <?php
                                }
                        ?> 

                        </form>

                        
                        <script type="text/javascript">
            
                            jQuery(document).ready(function() {
                                
                                jQuery('ul#sortable').nestedSortable({
                                        handle:             'div',
                                        tabSize:            20,
                                        listType:           'ul',
                                        items:              'li',
                                        toleranceElement:   '> div',
                                        placeholder:        'ui-sortable-placeholder',
                                        disableNesting:     'no-nesting'
                                        <?php
                            
                                            if ($is_hierarchical === TRUE)
                                                {
                                                }
                                                else
                                                {
                                                    ?>,disableNesting      :true<?php
                                                }
                                        ?>});
                                  
                                jQuery(".save-order").bind( "click", function() {
                                    jQuery(this).parent().find('img').show();
                                    
                                    var serialized = jQuery('ul#sortable').nestedSortable('serialize');
                                    
                                    jQuery.post( ajaxurl, { 
                                                                action:         'update-taxonomy-order', 
                                                                order:          jQuery("#sortable").nestedSortable("serialize"),
                                                                taxonomy:       taxonomy,
                                                                
                                                                nonce:          '<?php echo esc_attr ( wp_create_nonce( 'atto/interface/ajax_action' ) )   ?>'
                                    }, function() {
                                            jQuery("#ajax-response").html('<div class="message updated fade"><p><?php esc_html_e ( "Items Order Updated", 'advanced-taxonomy-terms-order' ) ?></p></div>');
                                            jQuery("#ajax-response div").delay(3000).hide("slow");
                                            jQuery('img.pto_ajax_loading').hide();
                                        });
                                });
                            });
                        </script>
                        
                    </div>
                    <?php 
 
                }
            
            
            function list_terms( $taxonomy ) 
                {

                    // Query pages.
                    $args = array(
                                'orderby'       =>  'term_order',
                                'depth'         =>  0,
                                'child_of'      =>  0,
                                'hide_empty'    =>  0,
                                
                                'taxonomy'      =>  $taxonomy  
                    );
                    
                    $args   =   apply_filters( 'atto/interface_query_args', $args, $taxonomy );
                    
                    $taxonomy_terms = get_terms( $args );

                    $output = '';
                    if (count($taxonomy_terms) > 0)
                        {
                            $output = $this->walk_tree($taxonomy_terms, $args['depth'], $args);    
                        }

                    //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                    echo $output; 
                    
                }
                
            function walk_tree($taxonomy_terms, $depth, $r) 
                {
                    $walker     = new ATTO_Terms_Walker; 
                    $args       = array($taxonomy_terms, $depth, $r);
                    
                    return call_user_func_array(array(&$walker, 'walk'), $args);
                }
                
                
                
   
            
        }
    
?>